from formatting import *
class Product:

    last_serial_number=0
    
    def __init__(self,name,price,*dimensions,**kwargs):
        self._name=name
        self._price=price
        self._dimensions=dimensions
        self._kwargs=kwargs
        Product.last_serial_number+=1
        self._serial_number=Product.last_serial_number

    @format_as_character
    def getName(self):
        return self._name

    @format_as_currency
    def getPrice(self):
        return self._price
        
    def printProduct(self):
        print("Product number: ",self._serial_number)
        print(self.getName(),self.getPrice())
        print("Weight (g), height (cm), length(cm), width(cm): "
              ,self._dimensions)
        for key,value in self._kwargs.items():
            print(key,": ",value) #include the : for formatting purposes

    @classmethod
    def _get_last_serial_number(cls):#the cls parameter refers to the class
        return cls.last_serial_number

    #Named constructors
    @classmethod
    def basic_product(cls,name,price):
        return cls(name,price)
    @classmethod
    def product_with_dimensions(cls,name,price,*dimensions):
        return cls(name,price,*dimensions)
            
